<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Notification;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\Notification\NotificationModel;
use Erlage\Photogram\Data\Dtos\Notification\NotificationLinkedContentDTO;

final class NotificationTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'notification';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    // ids

    const ID = 'id';

    // creds

    const TO_USER_ID = 'to_user_id';

    // linked

    const LINKED_CONTENT = 'linked_content';

    // super meta

    const TARGET_CONTENT_ID = 'target_content_id';

    // meta

    const META_TYPE = 'meta_type';

    const META_IS_READ = 'meta_is_read';

    const META_IS_TRANSIENT = 'meta_is_transient';

    // stamps

    const STAMP_REGISTRATION_DATE = 'stamp_registration_date';

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID                      => 'id',

        self::TO_USER_ID              => 'toUserId',

        self::TARGET_CONTENT_ID       => 'targetContentId',

        self::LINKED_CONTENT          => 'linkedContent',

        self::META_TYPE               => 'metaType',
        self::META_IS_READ            => 'metaIsRead',
        self::META_IS_TRANSIENT       => 'metaIsTransient',

        self::STAMP_REGISTRATION_DATE => 'stampRegistrationDate',
        self::STAMP_REGISTRATION      => 'stampRegistration',
        self::STAMP_LAST_UPDATE       => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::TO_USER_ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return NotificationModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }

    public static function protectedAttributes(): array
    {
        return array(
            self::TARGET_CONTENT_ID       => self::CAMEL_CASE_MAP[self::TARGET_CONTENT_ID],
            self::META_IS_TRANSIENT       => self::CAMEL_CASE_MAP[self::META_IS_TRANSIENT],
            self::STAMP_REGISTRATION_DATE => self::CAMEL_CASE_MAP[self::STAMP_REGISTRATION_DATE],
        );
    }

    /*
    |--------------------------------------------------------------------------
    | table modifiers
    |--------------------------------------------------------------------------
    */

    public static function serializers(): array
    {
        return array(
            self::LINKED_CONTENT => NotificationLinkedContentDTO::serializer(),
        );
    }

    public static function deSerializers(): array
    {
        return array(
            self::LINKED_CONTENT => NotificationLinkedContentDTO::deSerializer(),
        );
    }
}
